package com.chenyang.druid.sql.ast.statement;

import com.chenyang.druid.DbType;
import com.chenyang.druid.sql.ast.SQLName;
import com.chenyang.druid.sql.ast.SQLStatementImpl;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;

public class SQLPurgeTableStatement extends SQLStatementImpl implements SQLDropStatement {
   private SQLExprTableSource table;

   public SQLPurgeTableStatement() {
   }

   public SQLPurgeTableStatement(DbType dbType) {
      super(dbType);
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.table);
      }

      visitor.endVisit(this);
   }

   public SQLExprTableSource getTable() {
      return this.table;
   }

   public void setTable(SQLName x) {
      if (x == null) {
         this.table = null;
      } else {
         this.setTable(new SQLExprTableSource(x));
      }
   }

   public void setTable(SQLExprTableSource x) {
      if (x != null) {
         x.setParent(this);
      }

      this.table = x;
   }
}
