package com.chenyang.druid.sql.ast.statement;

import com.chenyang.druid.DbType;
import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.SQLName;
import com.chenyang.druid.sql.ast.SQLObject;
import com.chenyang.druid.sql.ast.SQLStatementImpl;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class SQLRollbackStatement extends SQLStatementImpl {
   private SQLName to;
   private boolean work = false;
   private Boolean chain;
   private Boolean release;
   private SQLExpr force;
   private boolean transaction;
   private boolean hasSavepoint;

   public SQLRollbackStatement() {
   }

   public SQLRollbackStatement(DbType dbType) {
      super(dbType);
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.to);
         this.acceptChild(visitor, this.force);
      }

      visitor.endVisit(this);
   }

   public List<SQLObject> getChildren() {
      List<SQLObject> children = new ArrayList();
      if (this.to != null) {
         children.add(this.to);
      }

      if (this.force != null) {
         children.add(this.force);
      }

      return children;
   }

   public SQLName getTo() {
      return this.to;
   }

   public void setTo(SQLName to) {
      this.to = to;
   }

   public Boolean getChain() {
      return this.chain;
   }

   public void setChain(Boolean chain) {
      this.chain = chain;
   }

   public Boolean getRelease() {
      return this.release;
   }

   public void setRelease(Boolean release) {
      this.release = release;
   }

   public SQLExpr getForce() {
      return this.force;
   }

   public void setForce(SQLExpr force) {
      this.force = force;
   }

   public boolean isWork() {
      return this.work;
   }

   public void setWork(boolean work) {
      this.work = work;
   }

   public boolean isTransaction() {
      return this.transaction;
   }

   public void setTransaction(boolean transaction) {
      this.transaction = transaction;
   }

   public boolean isHasSavepoint() {
      return this.hasSavepoint;
   }

   public void setHasSavepoint(boolean hasSavepoint) {
      this.hasSavepoint = hasSavepoint;
   }
}
