package com.chenyang.druid.sql.ast.statement;

import com.chenyang.druid.DbType;
import com.chenyang.druid.FastsqlException;
import com.chenyang.druid.sql.ast.SQLCommentHint;
import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.SQLName;
import com.chenyang.druid.sql.ast.SQLStatementImpl;
import com.chenyang.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.chenyang.druid.sql.ast.expr.SQLBinaryOperator;
import com.chenyang.druid.sql.ast.expr.SQLIntegerExpr;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class SQLSetStatement extends SQLStatementImpl {
   private Option option;
   private List<SQLAssignItem> items;
   private List<SQLCommentHint> hints;

   public SQLSetStatement() {
      this.items = new ArrayList();
   }

   public SQLSetStatement(DbType dbType) {
      super(dbType);
      this.items = new ArrayList();
   }

   public SQLSetStatement(SQLExpr target, SQLExpr value) {
      this(target, value, (DbType)null);
   }

   public SQLSetStatement(SQLExpr target, SQLExpr value, DbType dbType) {
      super(dbType);
      this.items = new ArrayList();
      SQLAssignItem item = new SQLAssignItem(target, value);
      item.setParent(this);
      this.items.add(item);
   }

   public static SQLSetStatement plus(SQLName target) {
      SQLExpr value = new SQLBinaryOpExpr(target.clone(), SQLBinaryOperator.Add, new SQLIntegerExpr(1));
      return new SQLSetStatement(target, value);
   }

   public List<SQLAssignItem> getItems() {
      return this.items;
   }

   public void setItems(List<SQLAssignItem> items) {
      this.items = items;
   }

   public List<SQLCommentHint> getHints() {
      return this.hints;
   }

   public void setHints(List<SQLCommentHint> hints) {
      this.hints = hints;
   }

   public Option getOption() {
      return this.option;
   }

   public void setOption(Option option) {
      this.option = option;
   }

   public void set(SQLExpr target, SQLExpr value) {
      SQLAssignItem assignItem = new SQLAssignItem(target, value);
      assignItem.setParent(this);
      this.items.add(assignItem);
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.items);
         this.acceptChild(visitor, this.hints);
      }

      visitor.endVisit(this);
   }

   public void output(Appendable buf) {
      try {
         buf.append("SET ");

         for(int i = 0; i < this.items.size(); ++i) {
            if (i != 0) {
               buf.append(", ");
            }

            SQLAssignItem item = (SQLAssignItem)this.items.get(i);
            item.output(buf);
         }

      } catch (IOException ex) {
         throw new FastsqlException("output error", ex);
      }
   }

   public SQLSetStatement clone() {
      SQLSetStatement x = new SQLSetStatement();

      for(SQLAssignItem item : this.items) {
         SQLAssignItem item2 = item.clone();
         item2.setParent(x);
         x.items.add(item2);
      }

      if (this.hints != null) {
         for(SQLCommentHint hint : this.hints) {
            SQLCommentHint h2 = hint.clone();
            h2.setParent(x);
            x.hints.add(h2);
         }
      }

      return x;
   }

   public List getChildren() {
      return this.items;
   }

   public static enum Option {
      IDENTITY_INSERT,
      PASSWORD,
      GLOBAL,
      SESSION,
      LOCAL;
   }
}
