package com.chenyang.druid.sql.ast.statement;

import com.chenyang.druid.DbType;
import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.SQLObject;
import com.chenyang.druid.sql.ast.SQLStatementImpl;
import com.chenyang.druid.sql.ast.expr.SQLCharExpr;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class SQLShowMaterializedViewStatement extends SQLStatementImpl implements SQLShowStatement {
   private SQLExpr name;
   private SQLCharExpr like;

   public SQLShowMaterializedViewStatement() {
   }

   public SQLShowMaterializedViewStatement(DbType dbType) {
      super(dbType);
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.name);
         this.acceptChild(visitor, this.like);
      }

      visitor.endVisit(this);
   }

   public SQLExpr getName() {
      return this.name;
   }

   public void setName(SQLExpr x) {
      if (x != null) {
         x.setParent(this);
      }

      this.name = x;
   }

   public SQLExpr getLike() {
      return this.like;
   }

   public void setLike(SQLCharExpr x) {
      if (x != null) {
         x.setParent(this);
      }

      this.like = x;
   }

   public List<SQLObject> getChildren() {
      List<SQLObject> children = new ArrayList();
      if (this.name != null) {
         children.add(this.name);
         children.add(this.like);
      }

      return children;
   }
}
