package com.chenyang.druid.sql.ast.statement;

import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.SQLLimit;
import com.chenyang.druid.sql.ast.SQLOrderBy;
import com.chenyang.druid.sql.ast.SQLReplaceable;
import com.chenyang.druid.sql.ast.SQLStatementImpl;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;

public class SQLShowQueryTaskStatement extends SQLStatementImpl implements SQLShowStatement, SQLReplaceable {
   private boolean full;
   private SQLExpr where;
   private SQLOrderBy orderBy;
   private SQLLimit limit;
   private SQLExpr user;

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.where);
         this.acceptChild(visitor, this.orderBy);
         this.acceptChild(visitor, this.limit);
         this.acceptChild(visitor, this.user);
      }

      visitor.endVisit(this);
   }

   public SQLExpr getWhere() {
      return this.where;
   }

   public void setWhere(SQLExpr x) {
      if (x != null) {
         x.setParent(this);
      }

      this.where = x;
   }

   public SQLExpr getUser() {
      return this.user;
   }

   public SQLExpr getFor() {
      return this.user;
   }

   public void setUser(SQLExpr user) {
      this.user = user;
   }

   public SQLOrderBy getOrderBy() {
      return this.orderBy;
   }

   public void setOrderBy(SQLOrderBy x) {
      if (x != null) {
         x.setParent(this);
      }

      this.orderBy = x;
   }

   public SQLLimit getLimit() {
      return this.limit;
   }

   public void setLimit(SQLLimit x) {
      if (x != null) {
         x.setParent(this);
      }

      this.limit = x;
   }

   public boolean replace(SQLExpr expr, SQLExpr target) {
      if (this.where == expr) {
         this.setWhere(target);
         return true;
      } else if (this.user == expr) {
         this.setUser(target);
         return true;
      } else {
         return false;
      }
   }

   public boolean isFull() {
      return this.full;
   }

   public void setFull(boolean full) {
      this.full = full;
   }
}
