package com.chenyang.druid.sql.ast.statement;

import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.SQLName;
import com.chenyang.druid.sql.ast.SQLReplaceable;
import com.chenyang.druid.sql.ast.SQLStatementImpl;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;

public class SQLShowViewsStatement extends SQLStatementImpl implements SQLShowStatement, SQLReplaceable {
   protected SQLName database;
   protected SQLExpr like;

   public SQLName getDatabase() {
      return this.database;
   }

   public void setDatabase(SQLName x) {
      if (x != null) {
         x.setParent(this);
      }

      this.database = x;
   }

   public SQLExpr getLike() {
      return this.like;
   }

   public void setLike(SQLExpr x) {
      if (x != null) {
         x.setParent(this);
      }

      this.like = x;
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.database);
         this.acceptChild(visitor, this.like);
      }

   }

   public boolean replace(SQLExpr expr, SQLExpr target) {
      if (this.database == expr) {
         this.setDatabase((SQLName)target);
         return true;
      } else if (this.like == expr) {
         this.setLike(target);
         return true;
      } else {
         return false;
      }
   }
}
