package com.chenyang.druid.sql.ast.statement;

import com.chenyang.druid.DbType;
import com.chenyang.druid.sql.ast.SQLCommentHint;
import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.SQLObject;
import com.chenyang.druid.sql.ast.SQLStatementImpl;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;
import java.util.Collections;
import java.util.List;

public class SQLStartTransactionStatement extends SQLStatementImpl {
   private boolean consistentSnapshot = false;
   private boolean begin = false;
   private boolean work = false;
   private SQLExpr name;
   private List<SQLCommentHint> hints;
   private IsolationLevel IsolationLevel;
   private boolean readOnly;

   public SQLStartTransactionStatement() {
   }

   public SQLStartTransactionStatement(DbType dbType) {
      this.dbType = dbType;
   }

   public boolean isConsistentSnapshot() {
      return this.consistentSnapshot;
   }

   public void setConsistentSnapshot(boolean consistentSnapshot) {
      this.consistentSnapshot = consistentSnapshot;
   }

   public boolean isBegin() {
      return this.begin;
   }

   public void setBegin(boolean begin) {
      this.begin = begin;
   }

   public boolean isWork() {
      return this.work;
   }

   public void setWork(boolean work) {
      this.work = work;
   }

   public IsolationLevel getIsolationLevel() {
      return this.IsolationLevel;
   }

   public void setIsolationLevel(IsolationLevel isolationLevel) {
      this.IsolationLevel = isolationLevel;
   }

   public void accept0(SQLASTVisitor visitor) {
      visitor.visit(this);
      visitor.endVisit(this);
   }

   public List<SQLCommentHint> getHints() {
      return this.hints;
   }

   public void setHints(List<SQLCommentHint> hints) {
      this.hints = hints;
   }

   public SQLExpr getName() {
      return this.name;
   }

   public void setName(SQLExpr name) {
      if (name != null) {
         name.setParent(this);
      }

      this.name = name;
   }

   public List<SQLObject> getChildren() {
      return this.name != null ? Collections.singletonList(this.name) : Collections.emptyList();
   }

   public boolean isReadOnly() {
      return this.readOnly;
   }

   public void setReadOnly(boolean readOnly) {
      this.readOnly = readOnly;
   }

   public static enum IsolationLevel {
      SERIALIZABLE("SERIALIZABLE"),
      REPEATABLE_READ("REPEATABLE READ"),
      READ_COMMITTED("READ COMMITTED"),
      READ_UNCOMMITTED("READ UNCOMMITTED");

      private final String text;

      private IsolationLevel(String text) {
         this.text = text;
      }

      public String getText() {
         return this.text;
      }
   }
}
