package com.chenyang.druid.sql.ast.statement;

import com.chenyang.druid.sql.ast.SQLObject;
import com.chenyang.druid.sql.ast.SQLStatement;
import com.chenyang.druid.sql.ast.SQLStatementImpl;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class SQLSubmitJobStatement extends SQLStatementImpl {
   private boolean await;
   private SQLStatement statment;

   public void accept0(SQLASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.statment);
      }

      visitor.endVisit(this);
   }

   public List<SQLObject> getChildren() {
      ArrayList<SQLObject> children = new ArrayList();
      children.add(this.statment);
      return children;
   }

   public boolean isAwait() {
      return this.await;
   }

   public void setAwait(boolean await) {
      this.await = await;
   }

   public SQLStatement getStatment() {
      return this.statment;
   }

   public void setStatment(SQLStatement statment) {
      this.statment = statment;
   }

   public SQLSubmitJobStatement clone() {
      SQLSubmitJobStatement x = new SQLSubmitJobStatement();
      if (this.statment != null) {
         x.setStatment(this.statment.clone());
      }

      return x;
   }
}
