package com.chenyang.druid.sql.ast.statement;

import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.SQLHint;
import com.chenyang.druid.sql.ast.SQLName;
import com.chenyang.druid.sql.ast.SQLReplaceable;
import com.chenyang.druid.sql.ast.expr.SQLIdentifierExpr;
import com.chenyang.druid.sql.ast.expr.SQLListExpr;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class SQLValuesTableSource extends SQLTableSourceImpl implements SQLSelectQuery, SQLReplaceable {
   private boolean bracket;
   private List<SQLListExpr> values = new ArrayList();
   private List<SQLName> columns = new ArrayList();

   public List<SQLListExpr> getValues() {
      return this.values;
   }

   public void addValue(SQLListExpr row) {
      if (row != null) {
         row.setParent(this);
         this.values.add(row);
      }
   }

   public List<SQLName> getColumns() {
      return this.columns;
   }

   public void addColumn(SQLName column) {
      column.setParent(this);
      this.columns.add(column);
   }

   public void addColumn(String column) {
      this.addColumn((SQLName)(new SQLIdentifierExpr(column)));
   }

   public void accept0(SQLASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.values);
         this.acceptChild(visitor, this.columns);
      }

      visitor.endVisit(this);
   }

   public boolean isBracket() {
      return this.bracket;
   }

   public void setBracket(boolean bracket) {
      this.bracket = bracket;
   }

   public SQLValuesTableSource clone() {
      SQLValuesTableSource x = new SQLValuesTableSource();
      x.setAlias(this.alias);

      for(SQLListExpr e : this.values) {
         SQLListExpr e2 = e.clone();
         e2.setParent(x);
         x.getValues().add(e2);
      }

      for(SQLName e : this.columns) {
         SQLName e2 = e.clone();
         e2.setParent(x);
         x.getColumns().add(e2);
      }

      if (this.flashback != null) {
         x.setFlashback(this.flashback.clone());
      }

      if (this.hints != null) {
         for(SQLHint e : this.hints) {
            SQLHint e2 = e.clone();
            e2.setParent(x);
            x.getHints().add(e2);
         }
      }

      return x;
   }

   public boolean replace(SQLExpr expr, SQLExpr target) {
      for(int i = 0; i < this.values.size(); ++i) {
         if (this.values.get(i) == expr) {
            target.setParent(this);
            this.values.set(i, (SQLListExpr)expr);
            return true;
         }
      }

      for(int i = 0; i < this.columns.size(); ++i) {
         if (this.columns.get(i) == expr) {
            target.setParent(this);
            this.columns.set(i, (SQLName)expr);
            return true;
         }
      }

      return false;
   }
}
