package com.chenyang.druid.sql.ast.statement;

import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.SQLObject;
import com.chenyang.druid.sql.ast.SQLReplaceable;
import com.chenyang.druid.sql.ast.SQLStatement;
import com.chenyang.druid.sql.ast.SQLStatementImpl;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class SQLWhileStatement extends SQLStatementImpl implements SQLReplaceable {
   private SQLExpr condition;
   private List<SQLStatement> statements = new ArrayList();
   private String labelName;

   public String getLabelName() {
      return this.labelName;
   }

   public void setLabelName(String labelName) {
      this.labelName = labelName;
   }

   public void accept0(SQLASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.condition);
         this.acceptChild(visitor, this.statements);
      }

      visitor.endVisit(this);
   }

   public List<SQLObject> getChildren() {
      List<SQLObject> children = new ArrayList();
      children.add(this.condition);
      children.addAll(this.statements);
      return children;
   }

   public List<SQLStatement> getStatements() {
      return this.statements;
   }

   public void setStatements(List<SQLStatement> statements) {
      this.statements = statements;
   }

   public SQLExpr getCondition() {
      return this.condition;
   }

   public void setCondition(SQLExpr x) {
      if (x != null) {
         x.setParent(this);
      }

      this.condition = x;
   }

   public SQLWhileStatement clone() {
      SQLWhileStatement x = new SQLWhileStatement();
      if (this.condition != null) {
         x.setCondition(this.condition.clone());
      }

      for(SQLStatement stmt : this.statements) {
         SQLStatement stmt2 = stmt.clone();
         stmt2.setParent(x);
         x.statements.add(stmt2);
      }

      x.labelName = this.labelName;
      return x;
   }

   public boolean replace(SQLExpr expr, SQLExpr target) {
      if (this.condition == expr) {
         this.setCondition(target);
         return true;
      } else {
         return false;
      }
   }
}
