package com.chenyang.druid.sql.builder;

import com.chenyang.druid.DbType;
import com.chenyang.druid.sql.builder.impl.SQLDeleteBuilderImpl;
import com.chenyang.druid.sql.builder.impl.SQLSelectBuilderImpl;
import com.chenyang.druid.sql.builder.impl.SQLUpdateBuilderImpl;

public class SQLBuilderFactory {
   public static SQLSelectBuilder createSelectSQLBuilder(DbType dbType) {
      return new SQLSelectBuilderImpl(dbType);
   }

   public static SQLSelectBuilder createSelectSQLBuilder(String sql, DbType dbType) {
      return new SQLSelectBuilderImpl(sql, dbType);
   }

   public static SQLDeleteBuilder createDeleteBuilder(DbType dbType) {
      return new SQLDeleteBuilderImpl(dbType);
   }

   public static SQLDeleteBuilder createDeleteBuilder(String sql, DbType dbType) {
      return new SQLDeleteBuilderImpl(sql, dbType);
   }

   public static SQLUpdateBuilder createUpdateBuilder(DbType dbType) {
      return new SQLUpdateBuilderImpl(dbType);
   }

   public static SQLUpdateBuilder createUpdateBuilder(String sql, DbType dbType) {
      return new SQLUpdateBuilderImpl(sql, dbType);
   }
}
