package com.chenyang.druid.sql.builder.impl;

import com.chenyang.druid.DbType;
import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.expr.SQLBooleanExpr;
import com.chenyang.druid.sql.ast.expr.SQLCharExpr;
import com.chenyang.druid.sql.ast.expr.SQLIntegerExpr;
import com.chenyang.druid.sql.ast.expr.SQLNullExpr;
import com.chenyang.druid.sql.ast.expr.SQLNumberExpr;
import com.chenyang.druid.sql.builder.SQLBuilder;

public class SQLBuilderImpl implements SQLBuilder {
   public static SQLExpr toSQLExpr(Object obj, DbType dbType) {
      if (obj == null) {
         return new SQLNullExpr();
      } else if (obj instanceof Integer) {
         return new SQLIntegerExpr((Integer)obj);
      } else if (obj instanceof Number) {
         return new SQLNumberExpr((Number)obj);
      } else if (obj instanceof String) {
         return new SQLCharExpr((String)obj);
      } else if (obj instanceof Boolean) {
         return new SQLBooleanExpr((Boolean)obj);
      } else {
         throw new IllegalArgumentException("not support : " + obj.getClass().getName());
      }
   }
}
