package com.chenyang.druid.sql.dialect.ads.visitor;

import com.chenyang.druid.DbType;
import com.chenyang.druid.sql.ast.statement.SQLAlterTableAddColumn;
import com.chenyang.druid.sql.ast.statement.SQLAssignItem;
import com.chenyang.druid.sql.ast.statement.SQLCreateTableStatement;
import com.chenyang.druid.sql.ast.statement.SQLShowColumnsStatement;
import com.chenyang.druid.sql.dialect.mysql.ast.MySqlPrimaryKey;
import com.chenyang.druid.sql.dialect.mysql.ast.statement.MySqlCreateTableStatement;
import com.chenyang.druid.sql.visitor.SQLASTOutputVisitor;
import java.util.List;

public class AdsOutputVisitor extends SQLASTOutputVisitor implements AdsVisitor {
   public AdsOutputVisitor(Appendable appender) {
      super(appender);
   }

   public AdsOutputVisitor(Appendable appender, DbType dbType) {
      super(appender, dbType);
   }

   public AdsOutputVisitor(Appendable appender, boolean parameterized) {
      super(appender, parameterized);
   }

   public boolean visit(SQLCreateTableStatement x) {
      this.printCreateTable(x, true);
      List<SQLAssignItem> options = x.getTableOptions();
      if (options.size() > 0) {
         this.println();
         this.print0(this.ucase ? "OPTIONS (" : "options (");
         this.printAndAccept(options, ", ");
         this.print(')');
      }

      return false;
   }

   public boolean visit(SQLAlterTableAddColumn x) {
      this.print0(this.ucase ? "ADD COLUMN " : "add column ");
      this.printAndAccept(x.getColumns(), ", ");
      return false;
   }

   public boolean visit(SQLShowColumnsStatement x) {
      this.print0(this.ucase ? "SHOW COLUMNS" : "show columns");
      if (x.getTable() != null) {
         this.print0(this.ucase ? " IN " : " in ");
         x.getTable().accept(this);
      }

      return false;
   }

   public void endVisit(MySqlPrimaryKey x) {
   }

   public void endVisit(MySqlCreateTableStatement x) {
   }
}
