package com.chenyang.druid.sql.dialect.blink.parser;

import com.chenyang.druid.DbType;
import com.chenyang.druid.sql.parser.Keywords;
import com.chenyang.druid.sql.parser.Lexer;
import com.chenyang.druid.sql.parser.SQLParserFeature;
import com.chenyang.druid.sql.parser.Token;
import java.util.HashMap;
import java.util.Map;

public class BlinkLexer extends Lexer {
   public static final Keywords DEFAULT_BLINK_KEYWORDS;

   public BlinkLexer(String input) {
      super(input);
      super.keywords = DEFAULT_BLINK_KEYWORDS;
      this.dbType = DbType.blink;
   }

   public BlinkLexer(String input, SQLParserFeature... features) {
      super(input);
      super.keywords = DEFAULT_BLINK_KEYWORDS;
      this.dbType = DbType.blink;

      for(SQLParserFeature feature : features) {
         this.config(feature, true);
      }

   }

   static {
      Map<String, Token> map = new HashMap();
      map.putAll(Keywords.DEFAULT_KEYWORDS.getKeywords());
      map.put("OF", Token.OF);
      map.put("CONCAT", Token.CONCAT);
      map.put("CONTINUE", Token.CONTINUE);
      map.put("MERGE", Token.MERGE);
      map.put("USING", Token.USING);
      map.put("ROW", Token.ROW);
      map.put("LIMIT", Token.LIMIT);
      map.put("IF", Token.IF);
      map.put("PERIOD", Token.PERIOD);
      DEFAULT_BLINK_KEYWORDS = new Keywords(map);
   }
}
