package com.chenyang.druid.sql.dialect.clickhouse.parser;

import com.chenyang.druid.DbType;
import com.chenyang.druid.sql.parser.Keywords;
import com.chenyang.druid.sql.parser.Lexer;
import com.chenyang.druid.sql.parser.SQLParserFeature;
import com.chenyang.druid.sql.parser.Token;
import java.util.HashMap;
import java.util.Map;

public class ClickhouseLexer extends Lexer {
   public static final Keywords DEFAULT_KEYWORDS;

   public ClickhouseLexer(String input) {
      super(input);
      this.dbType = DbType.clickhouse;
      super.keywords = DEFAULT_KEYWORDS;
   }

   public ClickhouseLexer(String input, SQLParserFeature... features) {
      super(input);
      super.keywords = DEFAULT_KEYWORDS;

      for(SQLParserFeature feature : features) {
         this.config(feature, true);
      }

   }

   static {
      Map<String, Token> map = new HashMap();
      map.putAll(Keywords.DEFAULT_KEYWORDS.getKeywords());
      map.put("OF", Token.OF);
      map.put("CONCAT", Token.CONCAT);
      map.put("CONTINUE", Token.CONTINUE);
      map.put("MERGE", Token.MERGE);
      map.put("USING", Token.USING);
      map.put("ROW", Token.ROW);
      map.put("LIMIT", Token.LIMIT);
      map.put("SHOW", Token.SHOW);
      map.put("ALL", Token.ALL);
      map.put("GLOBAL", Token.GLOBAL);
      DEFAULT_KEYWORDS = new Keywords(map);
   }
}
