package com.chenyang.druid.sql.dialect.db2.ast.expr;

import com.chenyang.druid.sql.SQLUtils;
import com.chenyang.druid.sql.ast.expr.SQLCastExpr;
import com.chenyang.druid.sql.dialect.db2.visitor.DB2ASTVisitor;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;

public class DB2TypeCastExpr extends SQLCastExpr implements DB2Expr {
   public void accept0(DB2ASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.expr);
         this.acceptChild(visitor, this.dataType);
      }

      visitor.endVisit(this);
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor instanceof DB2ASTVisitor) {
         this.accept0((DB2ASTVisitor)visitor);
      } else {
         super.accept0(visitor);
      }
   }

   public String toString() {
      return SQLUtils.toPGString(this);
   }
}
