package com.chenyang.druid.sql.dialect.db2.ast.expr.tablesource;

import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.SQLHint;
import com.chenyang.druid.sql.ast.SQLParameter;
import com.chenyang.druid.sql.ast.statement.SQLExprTableSource;
import com.chenyang.druid.sql.dialect.db2.ast.DB2SQLObject;
import com.chenyang.druid.sql.dialect.db2.visitor.DB2ASTVisitor;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class DB2FunctionTableSource extends SQLExprTableSource implements DB2SQLObject {
   private final List<SQLParameter> parameters = new ArrayList();

   public DB2FunctionTableSource() {
   }

   public DB2FunctionTableSource(SQLExpr expr) {
      this.expr = expr;
   }

   public List<SQLParameter> getParameters() {
      return this.parameters;
   }

   protected void accept0(SQLASTVisitor visitor) {
      this.accept0((DB2ASTVisitor)visitor);
   }

   public void accept0(DB2ASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.expr);
         this.acceptChild(visitor, this.parameters);
      }

      visitor.endVisit(this);
   }

   public DB2FunctionTableSource clone() {
      DB2FunctionTableSource x = new DB2FunctionTableSource();
      x.setAlias(this.alias);

      for(SQLParameter e : this.parameters) {
         SQLParameter e2 = e.clone();
         e2.setParent(x);
         x.getParameters().add(e2);
      }

      if (this.flashback != null) {
         x.setFlashback(this.flashback.clone());
      }

      if (this.hints != null) {
         for(SQLHint e : this.hints) {
            SQLHint e2 = e.clone();
            e2.setParent(x);
            x.getHints().add(e2);
         }
      }

      return x;
   }
}
