package com.chenyang.druid.sql.dialect.db2.ast.expr.tablesource;

import com.chenyang.druid.sql.ast.SQLName;
import com.chenyang.druid.sql.ast.statement.SQLSubqueryTableSource;
import com.chenyang.druid.sql.dialect.db2.ast.DB2SQLObject;
import com.chenyang.druid.sql.dialect.db2.visitor.DB2ASTVisitor;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;

public class DB2SubqueryTableSource extends SQLSubqueryTableSource implements DB2SQLObject, DB2TableSource {
   protected boolean only;

   public DB2SubqueryTableSource clone() {
      DB2SubqueryTableSource x = new DB2SubqueryTableSource();
      this.cloneTo(x);
      x.only = this.only;
      return x;
   }

   public void accept0(DB2ASTVisitor visitor) {
      if (visitor.visit(this) && this.select != null) {
         this.select.accept(visitor);
      }

      visitor.endVisit(this);
   }

   public void addColumnAlias(SQLName name) {
      if (this.columns == null) {
         this.columns = new ArrayList();
      }

      this.columns.add(name);
   }

   protected void accept0(SQLASTVisitor visitor) {
      this.accept0((DB2ASTVisitor)visitor);
   }

   public boolean isOnly() {
      return this.only;
   }

   public void setOnly(boolean only) {
      this.only = only;
   }
}
