package com.chenyang.druid.sql.dialect.db2.ast.stmt;

import com.chenyang.druid.DbType;
import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.SQLName;
import com.chenyang.druid.sql.ast.SQLStatementImpl;
import com.chenyang.druid.sql.ast.statement.SQLCreateStatement;
import com.chenyang.druid.sql.ast.statement.SQLUpdateSetItem;
import com.chenyang.druid.sql.dialect.db2.visitor.DB2ASTVisitor;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class DB2AlterTableSpaceStatement extends SQLStatementImpl implements SQLCreateStatement {
   private SQLName tableSpaceName;
   private boolean managedBy;
   private SQLName managedType;
   private boolean autoresize;
   private boolean yesOrNo;
   private boolean maxsize;
   private SQLExpr maxsizeNum;
   private boolean bufferpoo;
   private SQLExpr bufferpoolName;
   private boolean extentsize;
   private SQLExpr extentsizeNum;
   private List<SQLUpdateSetItem> parameterList = new ArrayList();

   public DB2AlterTableSpaceStatement() {
      this.dbType = DbType.db2;
   }

   public SQLName getTableSpaceName() {
      return this.tableSpaceName;
   }

   public void setTableSpaceName(SQLName tableSpaceName) {
      this.tableSpaceName = tableSpaceName;
   }

   public List<SQLUpdateSetItem> getParameterList() {
      return this.parameterList;
   }

   public void setParameterList(List<SQLUpdateSetItem> parameterList) {
      this.parameterList = parameterList;
   }

   public boolean isManagedBy() {
      return this.managedBy;
   }

   public void setManagedBy(boolean managedBy) {
      this.managedBy = managedBy;
   }

   public SQLName getManagedType() {
      return this.managedType;
   }

   public void setManagedType(SQLName managedType) {
      this.managedType = managedType;
   }

   public boolean isAutoresize() {
      return this.autoresize;
   }

   public void setAutoresize(boolean autoresize) {
      this.autoresize = autoresize;
   }

   public boolean isYesOrNo() {
      return this.yesOrNo;
   }

   public void setYesOrNo(boolean yesOrNo) {
      this.yesOrNo = yesOrNo;
   }

   public boolean isMaxsize() {
      return this.maxsize;
   }

   public void setMaxsize(boolean maxsize) {
      this.maxsize = maxsize;
   }

   public SQLExpr getMaxsizeNum() {
      return this.maxsizeNum;
   }

   public void setMaxsizeNum(SQLExpr maxsizeNum) {
      this.maxsizeNum = maxsizeNum;
   }

   public boolean isBufferpoo() {
      return this.bufferpoo;
   }

   public void setBufferpoo(boolean bufferpoo) {
      this.bufferpoo = bufferpoo;
   }

   public SQLExpr getBufferpoolName() {
      return this.bufferpoolName;
   }

   public void setBufferpoolName(SQLExpr bufferpoolName) {
      this.bufferpoolName = bufferpoolName;
   }

   public boolean isExtentsize() {
      return this.extentsize;
   }

   public void setExtentsize(boolean extentsize) {
      this.extentsize = extentsize;
   }

   public SQLExpr getExtentsizeNum() {
      return this.extentsizeNum;
   }

   public void setExtentsizeNum(SQLExpr extentsizeNum) {
      this.extentsizeNum = extentsizeNum;
   }

   public void accept0(SQLASTVisitor visitor) {
      this.accept0((DB2ASTVisitor)visitor);
   }

   public void accept0(DB2ASTVisitor visitor) {
      visitor.visit(this);
   }
}
