package com.chenyang.druid.sql.dialect.db2.ast.stmt;

import com.chenyang.druid.DbType;
import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.statement.SQLSetStatement;
import com.chenyang.druid.sql.dialect.db2.visitor.DB2ASTVisitor;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;

public class DB2SetConnectionStatement extends SQLSetStatement implements DB2SQLStatement {
   private SQLExpr hostType;
   private boolean database;
   private SQLExpr databaseName;
   private boolean ipaddr;
   private SQLExpr ipAddress;
   private boolean ipMask;
   private SQLExpr ipAddressMask;
   private boolean auth;
   private SQLExpr authType;

   public SQLExpr getHostType() {
      return this.hostType;
   }

   public void setHostType(SQLExpr hostType) {
      this.hostType = hostType;
   }

   public boolean isDatabase() {
      return this.database;
   }

   public void setDatabase(boolean database) {
      this.database = database;
   }

   public SQLExpr getDatabaseName() {
      return this.databaseName;
   }

   public void setDatabaseName(SQLExpr databaseName) {
      this.databaseName = databaseName;
   }

   public boolean isIpaddr() {
      return this.ipaddr;
   }

   public void setIpaddr(boolean ipaddr) {
      this.ipaddr = ipaddr;
   }

   public SQLExpr getIpAddress() {
      return this.ipAddress;
   }

   public void setIpAddress(SQLExpr ipAddress) {
      this.ipAddress = ipAddress;
   }

   public boolean isIpMask() {
      return this.ipMask;
   }

   public void setIpMask(boolean ipMask) {
      this.ipMask = ipMask;
   }

   public SQLExpr getIpAddressMask() {
      return this.ipAddressMask;
   }

   public void setIpAddressMask(SQLExpr ipAddressMask) {
      this.ipAddressMask = ipAddressMask;
   }

   public boolean isAuth() {
      return this.auth;
   }

   public void setAuth(boolean auth) {
      this.auth = auth;
   }

   public SQLExpr getAuthType() {
      return this.authType;
   }

   public void setAuthType(SQLExpr authType) {
      this.authType = authType;
   }

   public DB2SetConnectionStatement() {
      super(DbType.db2);
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor instanceof DB2ASTVisitor) {
         this.accept0((DB2ASTVisitor)visitor);
      } else {
         super.accept0(visitor);
      }

   }

   public void accept0(DB2ASTVisitor visitor) {
      if (visitor.visit(this)) {
      }

      visitor.endVisit(this);
   }
}
