package com.chenyang.druid.sql.dialect.db2.ast.stmt.alterTable;

import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.statement.SQLAlterTableItem;
import com.chenyang.druid.sql.dialect.db2.ast.DB2SQLObjectImpl;
import com.chenyang.druid.sql.dialect.db2.visitor.DB2ASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class DB2AlterTableSetNewTableSpace extends DB2SQLObjectImpl implements SQLAlterTableItem {
   private SQLExpr name;
   private List<SQLExpr> owners = new ArrayList();
   private SQLExpr newTablespace = null;
   private boolean nowait = false;

   public void accept0(DB2ASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.name);
         this.acceptChild(visitor, this.owners);
         this.acceptChild(visitor, this.newTablespace);
      }

      visitor.endVisit(this);
   }

   public void addOwner(SQLExpr owner) {
      owner.setParent(this);
      this.owners.add(owner);
   }

   public SQLExpr getNewTablespace() {
      return this.newTablespace;
   }

   public void setNewTablespace(SQLExpr newTablespace) {
      this.newTablespace = newTablespace;
      newTablespace.setParent(this);
   }

   public List<SQLExpr> getOwners() {
      return this.owners;
   }

   public void setOwners(List<SQLExpr> owners) {
      this.owners = owners;
   }

   public boolean isNowait() {
      return this.nowait;
   }

   public void setNowait(boolean nowait) {
      this.nowait = nowait;
   }

   public SQLExpr getName() {
      return this.name;
   }

   public void setName(SQLExpr name) {
      this.name = name;
      name.setParent(this);
   }

   public DB2AlterTableSetNewTableSpace clone() {
      DB2AlterTableSetNewTableSpace c = new DB2AlterTableSetNewTableSpace();
      c.setName(this.name.clone());

      for(SQLExpr owner : this.owners) {
         c.addOwner(owner.clone());
      }

      c.setNewTablespace(this.newTablespace.clone());
      c.nowait = this.nowait;
      return c;
   }
}
