package com.chenyang.druid.sql.dialect.dm.ast.clause;

import com.chenyang.druid.sql.ast.SQLName;
import com.chenyang.druid.sql.dialect.dm.ast.DmSQLObjectImpl;
import com.chenyang.druid.sql.dialect.dm.visitor.DmASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class DmPartitionExtensionClause extends DmSQLObjectImpl {
   private boolean subPartition;
   private SQLName partition;
   private final List<SQLName> target = new ArrayList();

   public boolean isSubPartition() {
      return this.subPartition;
   }

   public void setSubPartition(boolean subPartition) {
      this.subPartition = subPartition;
   }

   public SQLName getPartition() {
      return this.partition;
   }

   public void setPartition(SQLName partition) {
      this.partition = partition;
   }

   public List<SQLName> getFor() {
      return this.target;
   }

   public void accept0(DmASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.partition);
         this.acceptChild(visitor, this.target);
      }

      visitor.endVisit(this);
   }

   public DmPartitionExtensionClause clone() {
      DmPartitionExtensionClause x = new DmPartitionExtensionClause();
      x.subPartition = this.subPartition;
      if (this.partition != null) {
         x.setPartition(this.partition.clone());
      }

      for(SQLName item : this.target) {
         SQLName item1 = item.clone();
         item1.setParent(x);
         x.target.add(item1);
      }

      return x;
   }
}
