package com.chenyang.druid.sql.dialect.dm.ast.stmt;

import com.chenyang.druid.sql.ast.statement.SQLAlterTableItem;
import com.chenyang.druid.sql.ast.statement.SQLColumnDefinition;
import com.chenyang.druid.sql.dialect.dm.ast.DmSQLObjectImpl;
import com.chenyang.druid.sql.dialect.dm.visitor.DmASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class DmAlterTableModify extends DmSQLObjectImpl implements SQLAlterTableItem {
   private List<SQLColumnDefinition> columns = new ArrayList();

   public void accept0(DmASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.columns);
      }

      visitor.endVisit(this);
   }

   public List<SQLColumnDefinition> getColumns() {
      return this.columns;
   }

   public void addColumn(SQLColumnDefinition column) {
      if (column != null) {
         column.setParent(this);
      }

      this.columns.add(column);
   }
}
