package com.chenyang.druid.sql.dialect.dm.ast.stmt;

import com.chenyang.druid.DbType;
import com.chenyang.druid.sql.ast.SQLName;
import com.chenyang.druid.sql.ast.SQLObject;
import com.chenyang.druid.sql.ast.statement.SQLCreateIndexStatement;
import com.chenyang.druid.sql.ast.statement.SQLCreateStatement;
import com.chenyang.druid.sql.ast.statement.SQLDDLStatement;
import com.chenyang.druid.sql.dialect.dm.visitor.DmASTVisitor;
import com.chenyang.druid.sql.dialect.oracle.ast.OracleSegmentAttributes;
import com.chenyang.druid.sql.visitor.SQLASTOutputVisitor;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;

public class DmCreateIndexStatement extends SQLCreateIndexStatement implements SQLDDLStatement, OracleSegmentAttributes, SQLCreateStatement, DmStatement {
   private boolean online = false;
   private boolean context = false;
   private boolean cluster = false;
   private Boolean sort;
   private boolean orReplace = false;
   private boolean notPartial = false;
   private boolean reverse;
   private boolean sync;
   private boolean transaction;
   protected SQLName tablespace;
   protected SQLName lexer;
   protected SQLObject storage;
   private boolean global;

   public DmCreateIndexStatement() {
      super(DbType.dm);
   }

   public boolean isOrReplace() {
      return this.orReplace;
   }

   public boolean isNotPartial() {
      return this.notPartial;
   }

   public SQLName getLexer() {
      return this.lexer;
   }

   public void setLexer(SQLName lexer) {
      this.lexer = lexer;
   }

   public boolean isContext() {
      return this.context;
   }

   public void setContext(boolean context) {
      this.context = context;
   }

   public void setNotPartial(boolean notPartial) {
      this.notPartial = notPartial;
   }

   public void setOrReplace(boolean orReplace) {
      this.orReplace = orReplace;
   }

   public Boolean getSort() {
      return this.sort;
   }

   public void setSort(Boolean sort) {
      this.sort = sort;
   }

   public boolean isReverse() {
      return this.reverse;
   }

   public void setReverse(boolean reverse) {
      this.reverse = reverse;
   }

   public boolean isTransaction() {
      return this.transaction;
   }

   public void setTransaction(boolean transaction) {
      this.transaction = transaction;
   }

   public boolean isSync() {
      return this.sync;
   }

   public void setSync(boolean sync) {
      this.sync = sync;
   }

   protected void accept0(SQLASTVisitor v) {
      if (v instanceof DmASTVisitor) {
         this.accept0((DmASTVisitor)v);
      } else {
         if (v instanceof SQLASTOutputVisitor) {
            ((SQLASTOutputVisitor)v).print(this.toString());
         }

      }
   }

   public void accept0(DmASTVisitor visitor) {
      if (visitor.visit(this)) {
      }

      visitor.endVisit(this);
   }

   public boolean isOnline() {
      return this.online;
   }

   public void setOnline(boolean online) {
      this.online = online;
   }

   public boolean isCluster() {
      return this.cluster;
   }

   public void setCluster(boolean cluster) {
      this.cluster = cluster;
   }

   public SQLName getTablespace() {
      return this.tablespace;
   }

   public void setTablespace(SQLName tablespace) {
      if (tablespace != null) {
         tablespace.setParent(this);
      }

      this.tablespace = tablespace;
   }

   public Boolean getCompress() {
      return null;
   }

   public void setCompress(Boolean compress) {
   }

   public Integer getCompressLevel() {
      return null;
   }

   public void setCompressLevel(Integer compressLevel) {
   }

   public Integer getInitrans() {
      return null;
   }

   public void setInitrans(Integer initrans) {
   }

   public Integer getMaxtrans() {
      return null;
   }

   public void setMaxtrans(Integer maxtrans) {
   }

   public Integer getPctincrease() {
      return null;
   }

   public void setPctincrease(Integer pctincrease) {
   }

   public Integer getPctused() {
      return null;
   }

   public void setPctused(Integer pctused) {
   }

   public Integer getPctfree() {
      return null;
   }

   public void setPctfree(Integer ptcfree) {
   }

   public Boolean getLogging() {
      return null;
   }

   public void setLogging(Boolean logging) {
   }

   public SQLObject getStorage() {
      return this.storage;
   }

   public void setStorage(SQLObject storage) {
      this.storage = storage;
   }

   public boolean isCompressForOltp() {
      return false;
   }

   public void setCompressForOltp(boolean compressForOltp) {
   }

   public boolean isGlobal() {
      return this.global;
   }

   public void setGlobal(boolean global) {
      this.global = global;
   }
}
