package com.chenyang.druid.sql.dialect.dm.ast.stmt;

import com.chenyang.druid.DbType;
import com.chenyang.druid.sql.ast.SQLStatement;
import com.chenyang.druid.sql.ast.SQLStatementImpl;
import com.chenyang.druid.sql.ast.expr.SQLIdentifierExpr;
import com.chenyang.druid.sql.ast.statement.SQLCreateStatement;
import com.chenyang.druid.sql.dialect.dm.visitor.DmASTVisitor;
import com.chenyang.druid.sql.visitor.SQLASTOutputVisitor;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class DmCreateSchemaStatement extends SQLStatementImpl implements DmStatement, SQLCreateStatement {
   List<SQLStatement> stmtList = new ArrayList();
   private SQLIdentifierExpr schemaName;
   private SQLIdentifierExpr userName;
   private boolean authorization;

   public DmCreateSchemaStatement(DbType dbType) {
      this.dbType = dbType;
   }

   public SQLIdentifierExpr getSchemaName() {
      return this.schemaName;
   }

   public void setSchemaName(SQLIdentifierExpr schemaName) {
      this.schemaName = schemaName;
   }

   public SQLIdentifierExpr getUserName() {
      return this.userName;
   }

   public void setUserName(SQLIdentifierExpr userName) {
      this.userName = userName;
   }

   public boolean isAuthorization() {
      return this.authorization;
   }

   public void setAuthorization(boolean authorization) {
      this.authorization = authorization;
   }

   protected void accept0(SQLASTVisitor v) {
      if (v instanceof DmASTVisitor) {
         this.accept0((DmASTVisitor)v);
      } else {
         if (v instanceof SQLASTOutputVisitor) {
            ((SQLASTOutputVisitor)v).print(this.toString());
         }

      }
   }

   public void accept0(DmASTVisitor visitor) {
      if (visitor.visit(this)) {
      }

      visitor.endVisit(this);
   }

   public List<SQLStatement> getStmtList() {
      return this.stmtList;
   }

   public void setStmtList(List<SQLStatement> stmtList) {
      this.stmtList = stmtList;
   }
}
