package com.chenyang.druid.sql.dialect.dm.ast.stmt;

import com.chenyang.druid.sql.ast.SQLDataTypeImpl;
import com.chenyang.druid.sql.dialect.dm.ast.DMSQLObject;
import com.chenyang.druid.sql.dialect.dm.visitor.DmASTVisitor;
import com.chenyang.druid.sql.visitor.SQLASTOutputVisitor;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;

public class DmDataTypeIntervalYear extends SQLDataTypeImpl implements DMSQLObject {
   private boolean isToMonth = false;

   public DmDataTypeIntervalYear() {
      this.setName("INTERVAL YEAR");
   }

   protected void accept0(SQLASTVisitor v) {
      if (v instanceof DmASTVisitor) {
         this.accept0((DmASTVisitor)v);
      } else {
         if (v instanceof SQLASTOutputVisitor) {
            ((SQLASTOutputVisitor)v).print(this.toString());
         }

      }
   }

   public void accept0(DmASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.getArguments());
      }

      visitor.endVisit(this);
   }

   public DmDataTypeIntervalYear clone() {
      DmDataTypeIntervalYear x = new DmDataTypeIntervalYear();
      super.cloneTo(x);
      return x;
   }

   public boolean isToMonth() {
      return this.isToMonth;
   }

   public void setToMonth(boolean toMonth) {
      this.isToMonth = toMonth;
   }
}
