package com.chenyang.druid.sql.dialect.dm.ast.stmt;

import com.chenyang.druid.sql.dialect.dm.visitor.DmASTVisitor;

public class DmSetTransactionStatement extends DmStatementImpl {
   protected Level level;
   protected boolean readOnly = false;
   protected boolean readWrite = false;

   public boolean isReadOnly() {
      return this.readOnly;
   }

   public void setReadOnly(boolean readOnly) {
      this.readOnly = readOnly;
   }

   public boolean isReadWrite() {
      return this.readWrite;
   }

   public void setReadWrite(boolean readWrite) {
      this.readWrite = readWrite;
   }

   public Level getLevel() {
      return this.level;
   }

   public void setLevel(Level level) {
      this.level = level;
   }

   public void accept0(DmASTVisitor visitor) {
      if (visitor.visit(this)) {
      }

      visitor.endVisit(this);
   }

   public static enum Level {
      READ_COMMITTED("READ COMMITTED"),
      READ_UNCOMMITTED("READ UNCOMMITTED"),
      SERIALIZABLE("SERIALIZABLE");

      public final String name;

      private Level(String name) {
         this.name = name;
      }
   }
}
