package com.chenyang.druid.sql.dialect.dm.ast.stmt;

import com.chenyang.druid.DbType;
import com.chenyang.druid.sql.ast.statement.SQLUpdateStatement;
import com.chenyang.druid.sql.dialect.dm.ast.clause.DmReturningClause;
import com.chenyang.druid.sql.dialect.dm.visitor.DmASTVisitor;
import com.chenyang.druid.sql.visitor.SQLASTOutputVisitor;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;
import util.sqlparse.visitor.common.Objects;

public class DmUpdateStatement extends SQLUpdateStatement implements DmStatement {
   private DmReturningClause dmReturning;

   public boolean equals(Object o) {
      if (this == o) {
         return true;
      } else if (o != null && this.getClass() == o.getClass()) {
         if (!super.equals(o)) {
            return false;
         } else {
            DmUpdateStatement that = (DmUpdateStatement)o;
            return Objects.equals(this.dmReturning, that.dmReturning);
         }
      } else {
         return false;
      }
   }

   public int hashCode() {
      return Objects.hash(super.hashCode(), this.dmReturning);
   }

   public DmUpdateStatement() {
   }

   public DmUpdateStatement clone() {
      DmUpdateStatement x = new DmUpdateStatement();
      this.cloneTo(x);
      return x;
   }

   public void cloneTo(DmUpdateStatement x) {
      super.cloneTo(x);
      x.setDmReturning(this.dmReturning.clone());
   }

   public DmUpdateStatement(DbType dbType) {
      super(dbType);
   }

   public DmReturningClause getDmReturning() {
      return this.dmReturning;
   }

   public void setDmReturning(DmReturningClause dmReturning) {
      this.dmReturning = dmReturning;
   }

   public void accept0(DmASTVisitor visitor) {
      super.accept0(visitor);
      if (this.dmReturning != null) {
         this.dmReturning.accept0(visitor);
      }

   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor instanceof DmASTVisitor) {
         this.accept0((DmASTVisitor)visitor);
      } else if (visitor instanceof SQLASTOutputVisitor) {
         ((SQLASTOutputVisitor)visitor).print(this.toString());
      }

   }
}
