package com.chenyang.druid.sql.dialect.gauss.ast.expr;

import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.SQLObject;
import com.chenyang.druid.sql.dialect.gauss.ast.GaussSQLObjectImpl;
import com.chenyang.druid.sql.dialect.gauss.visitor.GaussASTVisitor;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class GaussOptionValue extends GaussSQLObjectImpl implements SQLExpr {
   protected SQLExpr option;
   protected SQLExpr value;
   private boolean eq = false;

   public boolean isEq() {
      return this.eq;
   }

   public void setEq(boolean eq) {
      this.eq = eq;
   }

   public SQLExpr getOption() {
      return this.option;
   }

   public void setOption(SQLExpr option) {
      this.option = option;
   }

   public SQLExpr getValue() {
      return this.value;
   }

   public void setValue(SQLExpr value) {
      this.value = value;
   }

   public void accept0(SQLASTVisitor visitor) {
      this.accept0((GaussASTVisitor)visitor);
   }

   public void accept0(GaussASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.option);
         if (this.value != null) {
            this.acceptChild(visitor, this.value);
         }
      }

      visitor.endVisit(this);
   }

   public void cloneTo(GaussOptionValue c) {
      c.setOption(this.option.clone());
      if (this.value != null) {
         c.setValue(this.value.clone());
      }

   }

   public GaussOptionValue clone() {
      GaussOptionValue c = new GaussOptionValue();
      this.cloneTo(c);
      return c;
   }

   public List<SQLObject> getChildren() {
      List<SQLObject> c = new ArrayList();
      c.add(this.option);
      if (this.value != null) {
         c.add(this.value);
      }

      return c;
   }
}
