package com.chenyang.druid.sql.dialect.gauss.ast.expr.tablesource;

import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.SQLName;
import com.chenyang.druid.sql.ast.statement.SQLExprTableSource;
import com.chenyang.druid.sql.dialect.gauss.ast.GaussSQLObject;
import com.chenyang.druid.sql.dialect.gauss.ast.expr.GaussColumnSimpleDefinitionExpr;
import com.chenyang.druid.sql.dialect.gauss.visitor.GaussASTVisitor;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;
import util.sqlparse.visitor.common.Objects;

public class GaussRowsFromTableSource extends SQLExprTableSource implements GaussSQLObject, GaussTableSource {
   protected boolean only;
   protected boolean withOrdinality;
   protected boolean isRowsFrom;
   protected List<GaussMethodInvokeTableSource> invokers = new ArrayList();
   protected List<SQLExpr> parameters = new ArrayList();
   protected List<GaussColumnSimpleDefinitionExpr> defines = new ArrayList();

   public List<GaussColumnSimpleDefinitionExpr> getDefines() {
      return this.defines;
   }

   public void setDefines(List<GaussColumnSimpleDefinitionExpr> defines) {
      this.defines = defines;
   }

   public boolean isRowsFrom() {
      return this.isRowsFrom;
   }

   public void setRowsFrom(boolean rowsFrom) {
      this.isRowsFrom = rowsFrom;
   }

   public List<GaussMethodInvokeTableSource> getInvokers() {
      return this.invokers;
   }

   public void setInvokers(List<GaussMethodInvokeTableSource> invokers) {
      this.invokers = invokers;
   }

   public List<SQLExpr> getParameters() {
      return this.parameters;
   }

   public void setParameters(List<SQLExpr> parameters) {
      this.parameters = parameters;
   }

   public boolean isOnly() {
      return this.only;
   }

   public void setOnly(boolean only) {
      this.only = only;
   }

   public boolean isWithOrdinality() {
      return this.withOrdinality;
   }

   public void setWithOrdinality(boolean withOrdinality) {
      this.withOrdinality = withOrdinality;
   }

   public void addTableSource(GaussMethodInvokeTableSource ts) {
      ts.setParent(this);
      this.invokers.add(ts);
   }

   public void addColumnAlias(SQLName name) {
      if (this.columns == null) {
         this.columns = new ArrayList();
      }

      this.columns.add(name);
   }

   public void addColumnAlias(GaussColumnSimpleDefinitionExpr define) {
      define.setParent(this);
      this.defines.add(define);
   }

   public boolean equals(Object o) {
      if (this == o) {
         return true;
      } else if (o != null && this.getClass() == o.getClass()) {
         if (!super.equals(o)) {
            return false;
         } else {
            GaussRowsFromTableSource that = (GaussRowsFromTableSource)o;
            return this.only == that.only && this.withOrdinality == that.withOrdinality && this.isRowsFrom == that.isRowsFrom && Objects.equals(this.invokers, that.invokers);
         }
      } else {
         return false;
      }
   }

   public int hashCode() {
      return Objects.hash(super.hashCode(), this.only, this.withOrdinality, this.isRowsFrom, this.invokers);
   }

   public void accept0(SQLASTVisitor visitor) {
      this.accept0((GaussASTVisitor)visitor);
   }

   public void accept0(GaussASTVisitor visitor) {
      if (visitor.visit(this)) {
         if (this.expr != null) {
            this.expr.accept(visitor);
         }

         if (this.parameters != null && this.parameters.size() > 0) {
            for(SQLExpr parameter : this.parameters) {
               parameter.accept(visitor);
            }
         }

         if (this.invokers != null && this.invokers.size() > 0) {
            for(GaussMethodInvokeTableSource parameter : this.invokers) {
               parameter.accept(visitor);
            }
         }

         if (this.sampling != null) {
            this.sampling.accept(visitor);
         }
      }

      visitor.endVisit(this);
   }
}
