package com.chenyang.druid.sql.dialect.gauss.ast.expr.tablesource;

import com.chenyang.druid.sql.ast.SQLName;
import com.chenyang.druid.sql.ast.statement.SQLSubqueryTableSource;
import com.chenyang.druid.sql.dialect.gauss.ast.GaussSQLObject;
import com.chenyang.druid.sql.dialect.gauss.visitor.GaussASTVisitor;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;

public class GaussSubqueryTableSource extends SQLSubqueryTableSource implements GaussSQLObject, GaussTableSource {
   protected boolean only;

   public GaussSubqueryTableSource clone() {
      GaussSubqueryTableSource x = new GaussSubqueryTableSource();
      this.cloneTo(x);
      x.only = this.only;
      return x;
   }

   public void accept0(GaussASTVisitor visitor) {
      if (visitor.visit(this) && this.select != null) {
         this.select.accept(visitor);
      }

      visitor.endVisit(this);
   }

   public void addColumnAlias(SQLName name) {
      if (this.columns == null) {
         this.columns = new ArrayList();
      }

      this.columns.add(name);
   }

   protected void accept0(SQLASTVisitor visitor) {
      this.accept0((GaussASTVisitor)visitor);
   }

   public boolean isOnly() {
      return this.only;
   }

   public void setOnly(boolean only) {
      this.only = only;
   }
}
