package com.chenyang.druid.sql.dialect.gauss.ast.stmt;

import com.chenyang.druid.DbType;
import com.chenyang.druid.sql.ast.SQLName;
import com.chenyang.druid.sql.ast.SQLStatementImpl;
import com.chenyang.druid.sql.dialect.gauss.visitor.GaussASTVisitor;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;

public class GaussConnectToStatement extends SQLStatementImpl implements GaussSQLStatement {
   private SQLName target;

   public GaussConnectToStatement() {
      super(DbType.gauss);
   }

   protected void accept0(SQLASTVisitor visitor) {
      this.accept0((GaussASTVisitor)visitor);
   }

   public void accept0(GaussASTVisitor v) {
      if (v.visit(this)) {
         this.acceptChild(v, this.target);
      }

      v.endVisit(this);
   }

   public SQLName getTarget() {
      return this.target;
   }

   public void setTarget(SQLName x) {
      if (x != null) {
         x.setParent(this);
      }

      this.target = x;
   }
}
