package com.chenyang.druid.sql.dialect.gauss.ast.stmt.alterTable;

import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.statement.SQLAlterTableItem;
import com.chenyang.druid.sql.dialect.gauss.ast.GaussSQLObjectImpl;
import com.chenyang.druid.sql.dialect.gauss.visitor.GaussASTVisitor;

public class GaussAlterTableDropColumn extends GaussSQLObjectImpl implements SQLAlterTableItem {
   private SQLExpr columnName;
   private DropColumType type;
   private boolean ifExists;

   public void accept0(GaussASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.columnName);
      }

      visitor.endVisit(this);
   }

   public boolean isIfExists() {
      return this.ifExists;
   }

   public void setIfExists(boolean ifExists) {
      this.ifExists = ifExists;
   }

   public DropColumType getType() {
      return this.type;
   }

   public void setType(DropColumType type) {
      this.type = type;
   }

   public SQLExpr getColumnName() {
      return this.columnName;
   }

   public void setColumnName(SQLExpr columnName) {
      columnName.setParent(this);
      this.columnName = columnName;
   }

   public GaussAlterTableDropColumn clone() {
      GaussAlterTableDropColumn c = new GaussAlterTableDropColumn();
      c.setColumnName(this.columnName.clone());
      c.ifExists = this.ifExists;
      c.type = this.type;
      return c;
   }

   public static enum DropColumType {
      restrict,
      cascade;
   }
}
