package com.chenyang.druid.sql.dialect.gauss.ast.stmt.alterTable;

import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.statement.SQLAlterTableItem;
import com.chenyang.druid.sql.dialect.gauss.ast.GaussSQLObject;
import com.chenyang.druid.sql.dialect.gauss.ast.GaussSQLObjectImpl;
import com.chenyang.druid.sql.dialect.gauss.visitor.GaussASTVisitor;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;

public class GaussAlterTableDropConstraint extends GaussSQLObjectImpl implements SQLAlterTableItem, GaussSQLObject {
   private SQLExpr constraint;
   private boolean ifExists;
   private DorpType type;

   public SQLExpr getConstraint() {
      return this.constraint;
   }

   public void setConstraint(SQLExpr constraint) {
      this.constraint = constraint;
      constraint.setParent(this);
   }

   public boolean isIfExists() {
      return this.ifExists;
   }

   public void setIfExists(boolean ifExists) {
      this.ifExists = ifExists;
   }

   public DorpType getType() {
      return this.type;
   }

   public void setType(DorpType type) {
      this.type = type;
   }

   public void accept0(SQLASTVisitor visitor) {
      this.accept0((GaussASTVisitor)visitor);
   }

   public void accept0(GaussASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.constraint.accept(visitor);
      }

      visitor.endVisit(this);
   }

   public GaussAlterTableDropConstraint clone() {
      GaussAlterTableDropConstraint c = new GaussAlterTableDropConstraint();
      c.setConstraint(this.constraint.clone());
      c.type = this.type;
      c.ifExists = this.ifExists;
      return c;
   }

   public static enum DorpType {
      restrict,
      cascade;
   }
}
