package com.chenyang.druid.sql.dialect.greenplum.ast.expr;

import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.SQLObject;
import com.chenyang.druid.sql.ast.SQLReplaceable;
import com.chenyang.druid.sql.dialect.greenplum.visitor.GPASTVisitor;
import java.util.Collections;
import java.util.List;

public class GPPointExpr extends GPExprImpl implements SQLReplaceable {
   private SQLExpr value;

   public GPPointExpr clone() {
      GPPointExpr x = new GPPointExpr();
      if (this.value != null) {
         x.setValue(this.value.clone());
      }

      return x;
   }

   public SQLExpr getValue() {
      return this.value;
   }

   public void setValue(SQLExpr value) {
      this.value = value;
   }

   public void accept0(GPASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.value);
      }

      visitor.endVisit(this);
   }

   public boolean replace(SQLExpr expr, SQLExpr target) {
      if (this.value == expr) {
         this.setValue(target);
         return true;
      } else {
         return false;
      }
   }

   public List<SQLObject> getChildren() {
      return Collections.singletonList(this.value);
   }

   public int hashCode() {
      int prime = 31;
      int result = 1;
      result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
      return result;
   }

   public boolean equals(Object obj) {
      if (this == obj) {
         return true;
      } else if (obj == null) {
         return false;
      } else if (this.getClass() != obj.getClass()) {
         return false;
      } else {
         GPPointExpr other = (GPPointExpr)obj;
         if (this.value == null) {
            if (other.value != null) {
               return false;
            }
         } else if (!this.value.equals(other.value)) {
            return false;
         }

         return true;
      }
   }
}
