package com.chenyang.druid.sql.dialect.greenplum.ast.stmt;

import com.chenyang.druid.DbType;
import com.chenyang.druid.sql.ast.statement.SQLDeleteStatement;
import com.chenyang.druid.sql.ast.statement.SQLTableSource;
import com.chenyang.druid.sql.dialect.greenplum.visitor.GPASTVisitor;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;
import java.util.List;

public class GPDeleteStatement extends SQLDeleteStatement implements GPSQLStatement {
   private boolean returning;
   protected List<SQLTableSource> usingList;

   public GPDeleteStatement() {
      super(DbType.greenplum);
   }

   public boolean isReturning() {
      return this.returning;
   }

   public void setReturning(boolean returning) {
      this.returning = returning;
   }

   public List<SQLTableSource> getUsingList() {
      return this.usingList;
   }

   public void setUsingList(List<SQLTableSource> usingList) {
      this.usingList = usingList;
   }

   public String getAlias() {
      return this.tableSource == null ? null : this.tableSource.getAlias();
   }

   public void setAlias(String alias) {
      this.tableSource.setAlias(alias);
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor instanceof GPASTVisitor) {
         this.accept0((GPASTVisitor)visitor);
      } else {
         super.accept0(visitor);
      }

   }

   public void accept0(GPASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.with);
         this.acceptChild(visitor, this.tableSource);
         this.acceptChild(visitor, this.using);
         this.acceptChild(visitor, this.where);
      }

      visitor.endVisit(this);
   }

   public GPDeleteStatement clone() {
      GPDeleteStatement x = new GPDeleteStatement();
      this.cloneTo(x);
      x.returning = this.returning;
      return x;
   }
}
