package com.chenyang.druid.sql.dialect.greenplum.ast.stmt.alterTable;

import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.statement.SQLAlterTableItem;
import com.chenyang.druid.sql.dialect.greenplum.ast.GPSQLObjectImpl;
import com.chenyang.druid.sql.dialect.greenplum.visitor.GPASTVisitor;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class GPAlterTableAlterColumnOptions extends GPSQLObjectImpl implements SQLAlterTableItem {
   private boolean set = false;
   private List<GPAlterTableAlterColumnOptionValue> options = new ArrayList();

   public boolean isSet() {
      return this.set;
   }

   public void setSet(boolean set) {
      this.set = set;
   }

   public List<GPAlterTableAlterColumnOptionValue> getOptions() {
      return this.options;
   }

   public void setOptions(List<GPAlterTableAlterColumnOptionValue> options) {
      this.options = options;
   }

   public void addOption(GPAlterTableAlterColumnOptionValue option) {
      this.options.add(option);
      option.setParent(this);
   }

   public void accept0(SQLASTVisitor visitor) {
      this.accept0((GPASTVisitor)visitor);
   }

   public void accept0(GPASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.options);
      }

      visitor.endVisit(this);
   }

   public GPAlterTableAlterColumnOptions clone() {
      GPAlterTableAlterColumnOptions c = new GPAlterTableAlterColumnOptions();
      c.set = this.set;

      for(GPAlterTableAlterColumnOptionValue option : this.options) {
         c.addOption(option.clone());
      }

      return c;
   }

   public static class GPAlterTableAlterColumnOptionValue extends GPSQLObjectImpl {
      private SQLExpr attribute;
      private SQLExpr value;

      public SQLExpr getAttribute() {
         return this.attribute;
      }

      public void setAttribute(SQLExpr attribute) {
         this.attribute = attribute;
         attribute.setParent(this);
      }

      public SQLExpr getValue() {
         return this.value;
      }

      public void setValue(SQLExpr value) {
         this.value = value;
         value.setParent(this);
      }

      public void accept0(SQLASTVisitor visitor) {
         this.accept0((GPASTVisitor)visitor);
      }

      public void accept0(GPASTVisitor visitor) {
         if (visitor.visit(this)) {
            this.acceptChild(visitor, this.attribute);
            this.acceptChild(visitor, this.value);
         }

         visitor.endVisit(this);
      }

      public GPAlterTableAlterColumnOptionValue clone() {
         GPAlterTableAlterColumnOptionValue option = new GPAlterTableAlterColumnOptionValue();
         option.setAttribute(this.attribute.clone());
         if (this.value != null) {
            option.setValue(this.value.clone());
         }

         return option;
      }
   }
}
