package com.chenyang.druid.sql.dialect.greenplum.ast.stmt.alterTable;

import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.statement.SQLAlterTableItem;
import com.chenyang.druid.sql.dialect.greenplum.ast.GPSQLObjectImpl;
import com.chenyang.druid.sql.dialect.greenplum.visitor.GPASTVisitor;

public class GPAlterTableRenameConstraint extends GPSQLObjectImpl implements SQLAlterTableItem {
   private SQLExpr col;
   private SQLExpr to;

   public void accept0(GPASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.col);
         this.acceptChild(visitor, this.to);
      }

      visitor.endVisit(this);
   }

   public SQLExpr getCol() {
      return this.col;
   }

   public void setCol(SQLExpr col) {
      col.setParent(this);
      this.col = col;
   }

   public SQLExpr getTo() {
      return this.to;
   }

   public void setTo(SQLExpr to) {
      to.setParent(this);
      this.to = to;
   }

   public GPAlterTableRenameConstraint clone() {
      GPAlterTableRenameConstraint c = new GPAlterTableRenameConstraint();
      c.setTo(this.to.clone());
      c.setCol(this.col.clone());
      return c;
   }
}
