package com.chenyang.druid.sql.dialect.hive.ast;

import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.SQLExprImpl;
import com.chenyang.druid.sql.dialect.hive.visitor.HiveASTVisitor;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;
import util.sqlparse.visitor.common.Objects;

public class HiveGrantPrinciple extends SQLExprImpl {
   private boolean user;
   private boolean role;
   private SQLExpr expr;

   public boolean isUser() {
      return this.user;
   }

   public void setUser(boolean user) {
      this.user = user;
   }

   public boolean isRole() {
      return this.role;
   }

   public void setRole(boolean role) {
      this.role = role;
   }

   public SQLExpr getExpr() {
      return this.expr;
   }

   public void setExpr(SQLExpr expr) {
      this.expr = expr;
      if (expr != null) {
         expr.setParent(this);
      }

   }

   protected void accept0(SQLASTVisitor v) {
      if (v instanceof HiveASTVisitor) {
         this.accpet0((HiveASTVisitor)v);
      }

   }

   protected void accpet0(HiveASTVisitor v) {
      if (v.visit(this) && this.expr != null) {
         this.acceptChild(v, this.expr);
      }

      v.endVisit(this);
   }

   public boolean equals(Object o) {
      if (this == o) {
         return true;
      } else if (o != null && this.getClass() == o.getClass()) {
         HiveGrantPrinciple that = (HiveGrantPrinciple)o;
         return this.user == that.user && this.role == that.role && Objects.equals(this.expr, that.expr);
      } else {
         return false;
      }
   }

   public int hashCode() {
      return Objects.hash(this.user, this.role, this.expr);
   }

   public SQLExpr clone() {
      HiveGrantPrinciple c = new HiveGrantPrinciple();
      c.setUser(this.user);
      c.setRole(this.role);
      c.setExpr(this.expr.clone());
      return c;
   }
}
