package com.chenyang.druid.sql.dialect.hive.ast.stmt;

import com.chenyang.druid.DbType;
import com.chenyang.druid.sql.ast.SQLCommentHint;
import com.chenyang.druid.sql.ast.SQLStatement;
import com.chenyang.druid.sql.ast.statement.SQLAssignItem;
import com.chenyang.druid.sql.ast.statement.SQLInsertStatement;
import com.chenyang.druid.sql.dialect.hive.visitor.HiveASTVisitor;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class HiveInsertStatement extends SQLInsertStatement implements SQLStatement {
   private boolean ifNotExists = false;
   protected List<SQLAssignItem> partitions;
   protected List<SQLAssignItem> partition;
   public boolean directory;
   public boolean local;

   public HiveInsertStatement() {
      this.dbType = DbType.hive;
      this.partitions = new ArrayList();
   }

   public HiveInsertStatement clone() {
      HiveInsertStatement x = new HiveInsertStatement();
      super.cloneTo(x);
      return x;
   }

   public void setDirSouece(boolean isDirectory) {
      this.directory = isDirectory;
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor instanceof HiveASTVisitor) {
         this.accept0((HiveASTVisitor)visitor);
      } else {
         super.accept0(visitor);
      }

   }

   protected void accept0(HiveASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.tableSource);
         this.acceptChild(visitor, this.partitions);
         this.acceptChild(visitor, this.valuesList);
         this.acceptChild(visitor, this.query);
      }

      visitor.endVisit(this);
   }

   public List<SQLCommentHint> getHeadHintsDirect() {
      return null;
   }

   public boolean isIfNotExists() {
      return this.ifNotExists;
   }

   public void setIfNotExists(boolean ifNotExists) {
      this.ifNotExists = ifNotExists;
   }
}
