package com.chenyang.druid.sql.dialect.kingbase.ast;

import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.SQLObjectImpl;
import com.chenyang.druid.sql.dialect.kingbase.visitor.KingbaseASTVisitor;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class ValueClause extends SQLObjectImpl {
   private List<Item> items = new ArrayList();

   public List<Item> getItems() {
      return this.items;
   }

   public void setItems(List<Item> items) {
      this.items = items;
   }

   protected void accept0(SQLASTVisitor v) {
      if (v instanceof KingbaseASTVisitor) {
         KingbaseASTVisitor visitor = (KingbaseASTVisitor)v;
         if (visitor.visit(this)) {
            for(Item item : this.items) {
               visitor.visit(item);
            }
         }
      }

   }

   public static class Item {
      private List<SQLExpr> values = new ArrayList();

      public List<SQLExpr> getValues() {
         return this.values;
      }

      public void setValues(List<SQLExpr> values) {
         this.values = values;
      }

      public void addValue(SQLExpr value) {
         this.values.add(value);
      }

      public void replace(SQLExpr value) {
      }

      public void remove(SQLExpr value) {
      }
   }
}
