package com.chenyang.druid.sql.dialect.kingbase.ast.expression;

import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.SQLObject;
import com.chenyang.druid.sql.ast.SQLReplaceable;
import com.chenyang.druid.sql.dialect.kingbase.KingbaseSQLObjectImpl;
import com.chenyang.druid.sql.dialect.kingbase.visitor.KingbaseASTVisitor;
import java.util.Collections;
import java.util.List;

public class KingbaseArgumentExpr extends KingbaseSQLObjectImpl implements SQLExpr, SQLReplaceable {
   private String argumentName;
   private SQLExpr value;

   public KingbaseArgumentExpr() {
   }

   public KingbaseArgumentExpr(String argumentName, SQLExpr value) {
      this.argumentName = argumentName;
      this.setValue(value);
   }

   public String getArgumentName() {
      return this.argumentName;
   }

   public void setArgumentName(String argumentName) {
      this.argumentName = argumentName;
   }

   public SQLExpr getValue() {
      return this.value;
   }

   public void setValue(SQLExpr value) {
      if (value != null) {
         value.setParent(this);
      }

      this.value = value;
   }

   public void accept0(KingbaseASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.value);
      }

      visitor.endVisit(this);
   }

   public KingbaseArgumentExpr clone() {
      KingbaseArgumentExpr x = new KingbaseArgumentExpr();
      x.argumentName = this.argumentName;
      if (this.value != null) {
         x.setValue(this.value.clone());
      }

      return x;
   }

   public boolean replace(SQLExpr expr, SQLExpr target) {
      if (this.value == expr) {
         this.setValue(target);
         return true;
      } else {
         return false;
      }
   }

   public List<SQLObject> getChildren() {
      return Collections.singletonList(this.value);
   }
}
