package com.chenyang.druid.sql.dialect.kingbase.ast.expression;

import com.chenyang.druid.sql.SQLUtils;
import com.chenyang.druid.sql.ast.expr.SQLCastExpr;
import com.chenyang.druid.sql.dialect.kingbase.KingbaseExpr;
import com.chenyang.druid.sql.dialect.kingbase.visitor.KingbaseASTVisitor;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;

public class KingbaseTypeCastExpr extends SQLCastExpr implements KingbaseExpr {
   public void accept0(KingbaseASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.expr);
         this.acceptChild(visitor, this.dataType);
      }

      visitor.endVisit(this);
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor instanceof KingbaseASTVisitor) {
         this.accept0((KingbaseASTVisitor)visitor);
      } else {
         super.accept0(visitor);
      }
   }

   public String toString() {
      return SQLUtils.toKingbaseString(this);
   }
}
