package com.chenyang.druid.sql.dialect.mariadb.ast;

import com.chenyang.druid.DbType;
import com.chenyang.druid.sql.ast.SQLName;
import com.chenyang.druid.sql.ast.statement.SQLForeignKeyImpl;
import com.chenyang.druid.sql.dialect.mysql.visitor.MySqlASTVisitor;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;

public class MariadbForeignKey extends SQLForeignKeyImpl {
   private SQLName indexName;
   private boolean hasConstraint;
   private Match referenceMatch;
   protected Option onUpdate;
   protected Option onDelete;

   public MariadbForeignKey() {
      this.dbType = DbType.mysql;
   }

   public SQLName getIndexName() {
      return this.indexName;
   }

   public void setIndexName(SQLName indexName) {
      this.indexName = indexName;
   }

   public boolean isHasConstraint() {
      return this.hasConstraint;
   }

   public void setHasConstraint(boolean hasConstraint) {
      this.hasConstraint = hasConstraint;
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor instanceof MySqlASTVisitor) {
         this.accept0((MySqlASTVisitor)visitor);
      }

   }

   protected void accept0(MySqlASTVisitor visitor) {
      if (visitor.visit((SQLForeignKeyImpl)this)) {
         this.acceptChild(visitor, this.getName());
         this.acceptChild(visitor, this.getReferencedTableName());
         this.acceptChild(visitor, this.getReferencingColumns());
         this.acceptChild(visitor, this.getReferencedColumns());
         this.acceptChild(visitor, this.indexName);
      }

      visitor.endVisit((SQLForeignKeyImpl)this);
   }

   public MariadbForeignKey clone() {
      MariadbForeignKey x = new MariadbForeignKey();
      this.cloneTo(x);
      if (this.indexName != null) {
         x.setIndexName(this.indexName.clone());
      }

      x.referenceMatch = this.referenceMatch;
      x.onUpdate = this.onUpdate;
      x.onDelete = this.onDelete;
      return x;
   }

   public Match getReferenceMatch() {
      return this.referenceMatch;
   }

   public void setReferenceMatch(Match referenceMatch) {
      this.referenceMatch = referenceMatch;
   }

   public Option getOnUpdate() {
      return this.onUpdate;
   }

   public void setOnUpdate(Option onUpdate) {
      this.onUpdate = onUpdate;
   }

   public Option getOnDelete() {
      return this.onDelete;
   }

   public void setOnDelete(Option onDelete) {
      this.onDelete = onDelete;
   }
}
