package com.chenyang.druid.sql.dialect.mariadb.ast.clause;

import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.SQLObject;
import com.chenyang.druid.sql.ast.SQLStatement;
import com.chenyang.druid.sql.ast.statement.SQLIfStatement;
import com.chenyang.druid.sql.dialect.mariadb.ast.MariadbObjectImpl;
import com.chenyang.druid.sql.dialect.mariadb.ast.statement.MariadbStatementImpl;
import com.chenyang.druid.sql.dialect.mariadb.visitor.MariadbASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class MariadbCaseStatement extends MariadbStatementImpl {
   private SQLExpr condition;
   private List<MariadbWhenStatement> whenList = new ArrayList();
   private SQLIfStatement.Else elseItem;

   public SQLExpr getCondition() {
      return this.condition;
   }

   public void setCondition(SQLExpr condition) {
      this.condition = condition;
   }

   public List<MariadbWhenStatement> getWhenList() {
      return this.whenList;
   }

   public void setWhenList(List<MariadbWhenStatement> whenList) {
      this.whenList = whenList;
   }

   public void addWhenStatement(MariadbWhenStatement stmt) {
      this.whenList.add(stmt);
   }

   public SQLIfStatement.Else getElseItem() {
      return this.elseItem;
   }

   public void setElseItem(SQLIfStatement.Else elseItem) {
      this.elseItem = elseItem;
   }

   public void accept0(MariadbASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.condition);
         this.acceptChild(visitor, this.whenList);
         this.acceptChild(visitor, this.elseItem);
      }

      visitor.endVisit(this);
   }

   public List<SQLObject> getChildren() {
      List<SQLObject> children = new ArrayList();
      children.addAll(children);
      children.addAll(this.whenList);
      children.addAll(this.whenList);
      if (this.elseItem != null) {
         children.add(this.elseItem);
      }

      return children;
   }

   public static class MariadbWhenStatement extends MariadbObjectImpl {
      private SQLExpr condition;
      private List<SQLStatement> statements = new ArrayList();

      public void accept0(MariadbASTVisitor visitor) {
         if (visitor.visit(this)) {
            this.acceptChild(visitor, this.condition);
            this.acceptChild(visitor, this.statements);
         }

         visitor.endVisit(this);
      }

      public SQLExpr getCondition() {
         return this.condition;
      }

      public void setCondition(SQLExpr condition) {
         this.condition = condition;
      }

      public List<SQLStatement> getStatements() {
         return this.statements;
      }

      public void setStatements(List<SQLStatement> statements) {
         this.statements = statements;
      }
   }
}
