package com.chenyang.druid.sql.dialect.mariadb.ast.clause;

import com.chenyang.druid.sql.SQLUtils;
import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.statement.SQLExprTableSource;
import java.util.ArrayList;
import java.util.List;

public class MariadbTableTableSource extends SQLExprTableSource {
   private List<SQLExpr> indexList;
   private List<SQLExpr> partitionList;
   private boolean partition;
   private SQLExpr indexOrKey;
   private boolean ignoreLeaves;
   private boolean all;

   public MariadbTableTableSource() {
      this.indexList = new ArrayList();
      this.partitionList = new ArrayList();
   }

   public MariadbTableTableSource(String tableName) {
      this(SQLUtils.toSQLExpr(tableName), null);
   }

   public MariadbTableTableSource(SQLExpr expr) {
      this(expr, null);
   }

   public List<SQLExpr> getIndexList() {
      return this.indexList;
   }

   public void setIndexList(List<SQLExpr> indexList) {
      this.indexList = indexList;
   }

   public boolean isPartition() {
      return this.partition;
   }

   public void setPartition(boolean partition) {
      this.partition = partition;
   }

   public SQLExpr getIndexOrKey() {
      return this.indexOrKey;
   }

   public void setIndexOrKey(SQLExpr indexOrKey) {
      this.indexOrKey = indexOrKey;
   }

   public boolean isIgnoreLeaves() {
      return this.ignoreLeaves;
   }

   public void setIgnoreLeaves(boolean ignoreLeaves) {
      this.ignoreLeaves = ignoreLeaves;
   }

   public boolean isAll() {
      return this.all;
   }

   public void setAll(boolean all) {
      this.all = all;
   }

   public List<SQLExpr> getPartitionList() {
      return this.partitionList;
   }

   public void setPartitionList(List<SQLExpr> partitionList) {
      this.partitionList = partitionList;
   }

   public MariadbTableTableSource(SQLExpr expr, String alias) {
      this.indexList = new ArrayList();
      this.partitionList = new ArrayList();
      this.setExpr(expr);
      this.setAlias(alias);
   }
}
