package com.chenyang.druid.sql.dialect.mariadb.ast.expr;

import com.chenyang.druid.FastsqlException;
import com.chenyang.druid.sql.ast.expr.SQLCharExpr;
import com.chenyang.druid.sql.dialect.mariadb.visitor.MariadbASTVisitor;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;
import java.io.IOException;

public class MariadbCharExpr extends SQLCharExpr implements MariadbExpr {
   private String charset;
   private String collate;
   private String type;

   public MariadbCharExpr() {
   }

   public MariadbCharExpr(String text) {
      super(text);
   }

   public MariadbCharExpr(String text, String charset) {
      super(text);
      this.charset = charset;
   }

   public MariadbCharExpr(String text, String charset, String collate) {
      super(text);
      this.charset = charset;
      this.collate = collate;
   }

   public String getCharset() {
      return this.charset;
   }

   public void setCharset(String charset) {
      this.charset = charset;
   }

   public String getCollate() {
      return this.collate;
   }

   public void setCollate(String collate) {
      this.collate = collate;
   }

   public String getType() {
      return this.type;
   }

   public void setType(String type) {
      this.type = type;
   }

   public void output(Appendable buf) {
      try {
         if (this.charset != null) {
            buf.append(this.charset);
            buf.append(' ');
         }

         if (super.text != null) {
            super.output(buf);
         }

         if (this.collate != null) {
            buf.append(" COLLATE ");
            buf.append(this.collate);
         }

      } catch (IOException ex) {
         throw new FastsqlException("output error", ex);
      }
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor instanceof MariadbASTVisitor) {
         this.accept0((MariadbASTVisitor)visitor);
      } else {
         visitor.visit((SQLCharExpr)this);
         visitor.endVisit((SQLCharExpr)this);
      }

   }

   public void accept0(MariadbASTVisitor visitor) {
      visitor.visit(this);
      visitor.endVisit(this);
   }

   public String toString() {
      StringBuffer buf = new StringBuffer();
      this.output(buf);
      return buf.toString();
   }

   public MariadbCharExpr clone() {
      MariadbCharExpr x = new MariadbCharExpr(this.text);
      x.collate = this.collate;
      x.charset = this.charset;
      x.type = this.type;
      return x;
   }
}
