package com.chenyang.druid.sql.dialect.mariadb.ast.statement;

import com.chenyang.druid.sql.ast.SQLStatement;
import com.chenyang.druid.sql.ast.statement.SQLSelect;
import com.chenyang.druid.sql.dialect.mariadb.visitor.MariadbASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class DrdsBaselineStatement extends MariadbStatementImpl implements SQLStatement {
   private String operation;
   private List<Long> baselineIds = new ArrayList();
   private SQLSelect select;

   public void accept0(MariadbASTVisitor visitor) {
      visitor.visit(this);
      visitor.endVisit(this);
   }

   public String getOperation() {
      return this.operation;
   }

   public void setOperation(String operation) {
      this.operation = operation;
   }

   public void addBaselineId(long id) {
      this.baselineIds.add(id);
   }

   public List<Long> getBaselineIds() {
      return this.baselineIds;
   }

   public SQLSelect getSelect() {
      return this.select;
   }

   public void setSelect(SQLSelect select) {
      this.select = select;
   }
}
