package com.chenyang.druid.sql.dialect.mariadb.ast.statement;

import com.chenyang.druid.sql.ast.SQLName;
import com.chenyang.druid.sql.ast.statement.SQLAlterStatement;
import com.chenyang.druid.sql.ast.statement.SQLAssignItem;
import com.chenyang.druid.sql.dialect.mariadb.ast.FullTextType;
import com.chenyang.druid.sql.dialect.mariadb.visitor.MariadbASTVisitor;

public class MariadbAlterFullTextStatement extends MariadbStatementImpl implements SQLAlterStatement {
   private FullTextType type;
   private SQLName name;
   private SQLAssignItem item;

   public SQLName getName() {
      return this.name;
   }

   public void setName(SQLName name) {
      if (name != null) {
         name.setParent(this);
      }

      this.name = name;
   }

   public FullTextType getType() {
      return this.type;
   }

   public void setType(FullTextType type) {
      this.type = type;
   }

   public SQLAssignItem getItem() {
      return this.item;
   }

   public void setItem(SQLAssignItem item) {
      if (item != null) {
         item.setParent(this);
      }

      this.item = item;
   }

   public void accept0(MariadbASTVisitor visitor) {
      visitor.visit(this);
      visitor.endVisit(this);
   }
}
