package com.chenyang.druid.sql.dialect.mariadb.ast.statement;

import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.SQLName;
import com.chenyang.druid.sql.ast.statement.SQLCreateStatement;
import com.chenyang.druid.sql.dialect.mariadb.visitor.MariadbASTVisitor;
import java.util.HashMap;
import java.util.Map;

public class MariadbAlterResourceGroupStatement extends MariadbStatementImpl implements SQLCreateStatement {
   private SQLName name;
   private Map<String, SQLExpr> properties = new HashMap();
   private Boolean enable;

   public SQLName getName() {
      return this.name;
   }

   public void setName(SQLName x) {
      if (x != null) {
         x.setParent(this);
      }

      this.name = x;
   }

   public void addProperty(String name, SQLExpr value) {
      if (value != null) {
         value.setParent(this);
      }

      this.properties.put(name, value);
   }

   public Boolean getEnable() {
      return this.enable;
   }

   public void setEnable(Boolean enable) {
      this.enable = enable;
   }

   public Map<String, SQLExpr> getProperties() {
      return this.properties;
   }

   public void accept0(MariadbASTVisitor v) {
      if (v.visit(this)) {
         this.acceptChild(v, this.name);

         for(SQLExpr value : this.properties.values()) {
            this.acceptChild(v, value);
         }
      }

      v.endVisit(this);
   }
}
